//
//  SpotlightQueryBasicsDemoWindowController.m
//  SimpleSearchApp
//
//  Created by ub on 24.07.09.
//  Copyright 2009 Udo Borkowski. All rights reserved.
//

#import "SpotlightQueryBasicsDemoWindowController.h"


@implementation SpotlightQueryBasicsDemoWindowController

@synthesize onlyTextFiles;

- (id)init
{
	if (![super initWithWindowNibName:@"SpotlightQueryBasicsDemoWindow"]) {
		return nil;
	}
	
	return self;
}

- (NSPredicate*)predicateForString:queryString;
{
	NSPredicate *predicate = [super predicateForString: queryString];

	if (self.onlyTextFiles) {
		// Create a compound predicate: (the inherited one) AND onlyTextFiles
		NSPredicate *onlyTextFilesPredicate = 
			[NSPredicate predicateWithFormat:@"kMDItemContentType == 'public.plain-text'"];
		predicate = [NSCompoundPredicate andPredicateWithSubpredicates:
					 [NSArray arrayWithObjects:predicate, onlyTextFilesPredicate, nil]];
	}
	
	return predicate;
}

- (void)setOnlyTextFiles:(BOOL)value;
{
    onlyTextFiles = value;
	[self updatePredicate];
}

- (IBAction)enableUpdates:(id)sender
{ 
	[self.query enableUpdates];
} 

- (IBAction)disableUpdates:(id)sender
{ 
	[self.query disableUpdates];
} 

- (IBAction)stopQuery:(id)sender
{ 
	[self.query stopQuery];
} 



@end
